import { DeploymentConfig, ProjectBuildConfig, BuildMetadataSchema as ServerBuildMetadataSchema, } from '@agentuity/server';
import { z as zod } from 'zod';
export { DeploymentConfig, ProjectBuildConfig };
export const ConfigSchema = zod.object({
    name: zod.string().describe('Profile name'),
    auth: zod
        .object({
        api_key: zod.string().optional().describe('API authentication key'),
        user_id: zod.string().optional().describe('User ID'),
        expires: zod.number().optional().describe('Authentication expiration timestamp'),
    })
        .optional()
        .describe('Authentication credentials (managed by login/logout commands)'),
    devmode: zod
        .object({
        hostname: zod.string().optional().describe('Development mode hostname'),
        privateKey: zod
            .string()
            .optional()
            .describe('Development mode private key (base64-encoded PEM)'),
    })
        .optional()
        .describe('Development mode configuration'),
    overrides: zod
        .object({
        api_url: zod.url().optional().describe('Override API base URL'),
        app_url: zod.url().optional().describe('Override app base URL'),
        transport_url: zod.url().optional().describe('Override transport URL'),
        stream_url: zod.url().optional().describe('Override stream URL'),
        kv_url: zod.url().optional().describe('Override keyvalue URL'),
        sandbox_url: zod.url().optional().describe('Override sandbox URL'),
        vector_url: zod.url().optional().describe('Override vector store URL'),
        catalyst_url: zod.url().optional().describe('Override catalyst URL'),
        ion_url: zod.url().optional().describe('Override ion URL'),
        gravity_url: zod.url().optional().describe('Override gravity URL'),
        skip_version_check: zod.boolean().optional().describe('Skip CLI version check on startup'),
    })
        .optional()
        .nullable()
        .describe('URL and behavior overrides'),
    preferences: zod
        .object({
        last_update_check: zod.number().optional().describe('Last update check timestamp'),
        last_legacy_warning: zod.number().optional().describe('Last legacy CLI warning timestamp'),
        signup_banner_shown: zod.boolean().optional().describe('If the signup banner was shown'),
        orgId: zod.string().optional().describe('Default organization ID'),
        projectId: zod.string().optional().describe('Default project ID'),
        region: zod.string().optional().describe('Default cloud region'),
        project_dir: zod.string().optional().describe('Last used project directory'),
    })
        .optional()
        .describe('User preferences'),
    gravity: zod
        .object({
        version: zod.string().optional().describe('The current gravity version'),
        checked: zod.number().optional().describe('Last gravity check timestamp'),
    })
        .optional()
        .describe('the gravity client information'),
});
export function createSubcommand(definition) {
    return definition;
}
export function createCommand(definition) {
    return definition;
}
const TemplateResourceSchema = zod.object({
    type: zod.enum(['database', 'queue']).describe('the type of resource required'),
    envVar: zod.string().describe('the environment variable that holds the resource connection info'),
    description: zod.string().optional().describe('human-readable description of the resource'),
    defaultName: zod
        .string()
        .optional()
        .describe('suggested default name when provisioning this resource'),
    queueType: zod
        .enum(['worker', 'pubsub'])
        .optional()
        .describe('queue type — required when type is "queue"'),
});
const TemplateEnvSchema = zod.object({
    key: zod.string().describe('the environment variable name'),
    required: zod.boolean().describe('whether this env var is required'),
    description: zod.string().optional().describe('human-readable description'),
    secret: zod.boolean().optional().describe('whether this env var is a secret'),
    defaultValue: zod.string().optional().describe('default or example value'),
});
const TemplateSchema = zod.object({
    source: zod
        .string()
        .optional()
        .describe('where the template came from (e.g. github.com/owner/repo)'),
    requirements: zod
        .object({
        resources: zod
            .array(TemplateResourceSchema)
            .optional()
            .describe('platform resources the project needs'),
        env: zod
            .array(TemplateEnvSchema)
            .optional()
            .describe('environment variables the project needs'),
    })
        .optional()
        .describe('what the template requires to run'),
});
export const ProjectSchema = zod.object({
    projectId: zod.string().describe('the project id'),
    orgId: zod.string().describe('the organization id'),
    region: zod.string().describe('the region identifier that the project is deployed into'),
    deployment: DeploymentConfig.optional().describe('the deployment configuration'),
    build: ProjectBuildConfig.optional().describe('the CI/CD build configuration'),
    skipGitSetup: zod
        .boolean()
        .optional()
        .describe('whether to skip the git integration setup prompt during deploy'),
    template: TemplateSchema.optional().describe('template metadata and requirements'),
});
export const BuildMetadataSchema = ServerBuildMetadataSchema;
/**
 * Common git options schema for build commands (deploy, snapshot build, etc.)
 * These can be provided via CLI flags to override auto-detected git values.
 */
export const GitOptionsSchema = zod.object({
    message: zod.string().optional().describe('The message to associate with this build'),
    commit: zod.string().optional().describe('The git commit SHA'),
    branch: zod.string().optional().describe('The git branch'),
    repo: zod.string().optional().describe('The git repo URL'),
    provider: zod.string().optional().describe('The git provider (github, gitlab, bitbucket)'),
    commitUrl: zod.url().optional().describe('The URL to the commit'),
});
export const DeployOptionsSchema = zod
    .object({
    logsUrl: zod.url().optional().describe('The url to the CI build logs'),
    trigger: zod
        .enum(['cli', 'workflow', 'webhook'])
        .default('cli')
        .optional()
        .describe('The trigger that caused the build'),
    event: zod
        .enum(['pull_request', 'push', 'manual', 'workflow'])
        .default('manual')
        .optional()
        .describe('The event that triggered the deployment'),
    pullRequestNumber: zod.number().optional().describe('the pull request number'),
    pullRequestUrl: zod.url().optional().describe('the pull request url'),
})
    .merge(GitOptionsSchema);
//# sourceMappingURL=types.js.map