import { z } from 'zod';
import { type Logger } from '@agentuity/core';
import { type BuildMetadata } from '@agentuity/server';
import { APIClient as ServerAPIClient } from '@agentuity/server';
import type { Config, Profile, AuthData } from './types';
import { ProjectSchema } from './types';
export declare const defaultProfileName = "production";
export declare function getDefaultConfigDir(): string;
export declare function getDefaultConfigPath(): string;
export declare function getProfilePath(): string;
export declare function ensureConfigDir(): Promise<void>;
export declare function saveProfile(path: string): Promise<void>;
export declare function getProfile(profileFromFlag?: string): Promise<string>;
export declare function fetchProfiles(): Promise<Profile[]>;
export declare function loadConfig(customPath?: string, skipCache?: boolean, profileFromFlag?: string): Promise<Config | null>;
export declare function saveConfig(config: Config, customPath?: string): Promise<void>;
export declare function getOrInitConfig(): Promise<Config>;
export declare function saveAuth(auth: AuthData): Promise<void>;
export declare function clearAuth(): Promise<void>;
export declare function saveProjectDir(projectDir: string): Promise<void>;
export declare function saveOrgId(orgId: string): Promise<void>;
export declare function saveProjectId(projectId: string): Promise<void>;
export declare function clearOrgId(): Promise<void>;
export declare function clearProjectId(): Promise<void>;
export declare function saveRegion(region: string): Promise<void>;
export declare function clearRegion(): Promise<void>;
export declare function getAuth(): Promise<AuthData | null>;
export declare function generateYAMLTemplate(name: string): string;
export declare const ProjectConfigNotFoundException: {
    new (args?: {
        message?: string;
        cause?: unknown;
    } | undefined): import("@agentuity/core").RichError & {
        readonly _tag: "ProjectConfigNotFoundException";
    } & Readonly<Record<string, never>>;
    readonly defaultMessage?: string;
} & (<Shape extends {
    [x: string]: any;
} = Record<string, never>>() => {
    new (args?: (Shape extends Record<string, never> ? {
        message?: string;
        cause?: unknown;
    } : Shape & {
        message?: string;
        cause?: unknown;
    }) | undefined): import("@agentuity/core").RichError & {
        readonly _tag: "ProjectConfigNotFoundException";
    } & Readonly<Shape>;
    readonly defaultMessage?: string;
});
type ProjectConfig = z.infer<typeof ProjectSchema>;
export declare function loadProjectConfig(dir: string, config?: Config | null): Promise<ProjectConfig>;
export declare const InitialProjectConfigSchema: z.ZodIntersection<z.ZodObject<{
    projectId: z.ZodString;
    orgId: z.ZodString;
    region: z.ZodString;
    deployment: z.ZodOptional<z.ZodObject<{
        resources: z.ZodOptional<z.ZodObject<{
            memory: z.ZodDefault<z.ZodString>;
            cpu: z.ZodDefault<z.ZodString>;
            disk: z.ZodDefault<z.ZodString>;
        }, z.core.$strip>>;
        mode: z.ZodOptional<z.ZodObject<{
            type: z.ZodDefault<z.ZodEnum<{
                "on-demand": "on-demand";
                provisioned: "provisioned";
            }>>;
            idle: z.ZodOptional<z.ZodString>;
        }, z.core.$strip>>;
        dependencies: z.ZodOptional<z.ZodArray<z.ZodString>>;
        domains: z.ZodOptional<z.ZodArray<z.ZodString>>;
    }, z.core.$strip>>;
    build: z.ZodOptional<z.ZodObject<{
        timeout: z.ZodOptional<z.ZodString>;
        resources: z.ZodOptional<z.ZodObject<{
            memory: z.ZodOptional<z.ZodString>;
            cpu: z.ZodOptional<z.ZodString>;
            disk: z.ZodOptional<z.ZodString>;
        }, z.core.$strip>>;
    }, z.core.$strip>>;
    skipGitSetup: z.ZodOptional<z.ZodBoolean>;
    template: z.ZodOptional<z.ZodObject<{
        source: z.ZodOptional<z.ZodString>;
        requirements: z.ZodOptional<z.ZodObject<{
            resources: z.ZodOptional<z.ZodArray<z.ZodObject<{
                type: z.ZodEnum<{
                    database: "database";
                    queue: "queue";
                }>;
                envVar: z.ZodString;
                description: z.ZodOptional<z.ZodString>;
                defaultName: z.ZodOptional<z.ZodString>;
                queueType: z.ZodOptional<z.ZodEnum<{
                    worker: "worker";
                    pubsub: "pubsub";
                }>>;
            }, z.core.$strip>>>;
            env: z.ZodOptional<z.ZodArray<z.ZodObject<{
                key: z.ZodString;
                required: z.ZodBoolean;
                description: z.ZodOptional<z.ZodString>;
                secret: z.ZodOptional<z.ZodBoolean>;
                defaultValue: z.ZodOptional<z.ZodString>;
            }, z.core.$strip>>>;
        }, z.core.$strip>>;
    }, z.core.$strip>>;
}, z.core.$strip>, z.ZodObject<{
    sdkKey: z.ZodString;
    $schema: z.ZodOptional<z.ZodString>;
}, z.core.$strip>>;
type InitialProjectConfig = z.infer<typeof InitialProjectConfigSchema>;
export declare function createProjectConfig(dir: string, config: InitialProjectConfig): Promise<void>;
export declare function updateProjectConfig(dir: string, updates: Partial<z.infer<typeof ProjectSchema>>, config?: Config | null): Promise<void>;
export declare function loadBuildMetadata(dir: string): Promise<BuildMetadata>;
export declare function loadProjectSDKKey(logger: Logger, projectDir: string): Promise<string | undefined>;
export declare function getCatalystAPIClient(logger: Logger, auth: AuthData, region: string, orgId?: string): ServerAPIClient;
/**
 * Get the default region using priority ordering:
 * 1. AGENTUITY_REGION environment variable
 * 2. 'local' for local profile
 * 3. Saved region preference (config.preferences.region)
 * 4. First entry in region-{profile}.json (nearest region, sorted by distance)
 * 5. 'usc' fallback
 *
 * Used for API calls that can hit any Catalyst instance (global database operations).
 * Note: This is NOT called when --region flag is provided (handled at command level).
 */
export declare function getDefaultRegion(profileName?: string, config?: Config | null): Promise<string>;
/**
 * Get a Catalyst API client for global database operations.
 * Uses the default region since the admin DB is global.
 *
 * @param logger - Logger instance
 * @param auth - Authentication data
 * @param profileName - Profile name (default: 'production')
 * @param orgId - Optional organization ID for CLI key authentication
 * @param config - Optional config for region preference lookup
 */
export declare function getGlobalCatalystAPIClient(logger: Logger, auth: AuthData, profileName?: string, orgId?: string, config?: Config | null): Promise<ServerAPIClient>;
export declare function getIONHost(config: Config | null, region: string): string;
export declare function getStreamURL(region: string, config: Config | null): string;
export {};
//# sourceMappingURL=config.d.ts.map