import type { Logger } from '@agentuity/core';
import type { APIClient } from '../../api';
import type { AuthData, Config } from '../../types';
interface CreateFlowOptions {
    projectName?: string;
    dir?: string;
    domains?: string[];
    template?: string;
    templateDir?: string;
    templateBranch?: string;
    noInstall: boolean;
    noBuild: boolean;
    skipPrompts: boolean;
    logger: Logger;
    auth?: AuthData;
    config?: Config;
    orgId?: string;
    region?: string;
    apiClient?: APIClient;
    database?: string;
    storage?: string;
    enableAuth?: boolean;
}
export interface CreateFlowResult {
    projectId?: string;
    orgId?: string;
    name: string;
    path: string;
    template: string;
    installed: boolean;
    built: boolean;
    domains?: string[];
    success: boolean;
    error?: string;
}
export declare function runCreateFlow(options: CreateFlowOptions): Promise<CreateFlowResult>;
export {};
//# sourceMappingURL=template-flow.d.ts.map