import { type Logger } from '@agentuity/core';
import type { APIClient } from '../../api';
import type { AuthData, Config } from '../../types';
export interface RemoteImportOptions {
    url: string;
    deploy: boolean;
    projectId?: string;
    repo?: string;
    name?: string;
    env?: string[];
    org?: string;
    region?: string;
    apiClient: APIClient;
    auth: AuthData;
    config: Config;
    logger: Logger;
}
interface ParsedGitHubUrl {
    owner: string;
    repo: string;
    branch: string;
    directory?: string;
}
/**
 * Parse a GitHub URL into its components.
 *
 * Supported formats:
 *   https://github.com/owner/repo
 *   https://github.com/owner/repo/tree/branch
 *   https://github.com/owner/repo/tree/branch/path/to/dir
 *
 * When the URL does not include a branch (no `/tree/…` segment), the GitHub
 * API is queried to discover the repository's default branch.
 */
export declare function parseGitHubUrl(url: string, apiClient: APIClient): Promise<ParsedGitHubUrl>;
/**
 * Run the remote import flow: download from GitHub, set up project, optionally push and deploy.
 */
export declare function runRemoteImport(options: RemoteImportOptions): Promise<void>;
export {};
//# sourceMappingURL=remote-import.d.ts.map