import { type Logger } from '@agentuity/core';
import type { TemplateInfo } from './templates';
interface DownloadOptions {
    dest: string;
    template: TemplateInfo;
    templateDir?: string;
    templateBranch?: string;
    logger: Logger;
}
interface SetupOptions {
    dest: string;
    projectName: string;
    dirName: string;
    noInstall: boolean;
    noBuild: boolean;
    logger: Logger;
}
export declare function downloadTemplate(options: DownloadOptions): Promise<void>;
export declare function setupProject(options: SetupOptions): Promise<{
    success: boolean;
}>;
interface InitGitRepoOptions {
    /** Project name (e.g. "My Agent") */
    projectName?: string;
    /** Where the template came from (e.g. "github.com/owner/repo" or "TypeScript / Hello World") */
    source?: string;
    /** Git commit author (e.g. { name: "app-slug[bot]", email: "id+slug[bot]@users.noreply.github.com" }) */
    author?: {
        name: string;
        email: string;
    };
}
export declare function initGitRepo(dest: string, options?: InitGitRepoOptions): Promise<void>;
export {};
//# sourceMappingURL=download.d.ts.map