import { getGlobalCatalystAPIClient } from '../../../config';
/**
 * Creates an API client for webhook operations.
 *
 * Webhooks are global resources that don't require a project context.
 * Uses the global Catalyst API client with user authentication.
 */
export async function createWebhookAPIClient(ctx) {
    return getGlobalCatalystAPIClient(ctx.logger, ctx.auth, ctx.config?.name);
}
/**
 * Creates WebhookApiOptions from the CLI context.
 * Prioritizes explicit orgId on context, then falls back to global --org-id option,
 * and finally to the preferred org from the profile configuration.
 */
export function getWebhookApiOptions(ctx) {
    const orgId = ctx.orgId ?? ctx.options.orgId ?? ctx.config?.preferences?.orgId;
    return orgId ? { orgId } : undefined;
}
//# sourceMappingURL=util.js.map