import { TaskStorageService } from '@agentuity/core';
import { createServerFetchAdapter } from '@agentuity/server';
import { getCatalystUrl } from '../../../catalyst';
import { setResourceInfo } from '../../../cache';
import { defaultProfileName, getDefaultRegion } from '../../../config';
import * as tui from '../../../tui';
export async function createStorageAdapter(ctx) {
    const orgId = ctx.options.orgId ??
        (process.env.AGENTUITY_CLOUD_ORG_ID || ctx.config?.preferences?.orgId);
    if (!orgId) {
        tui.fatal('Organization ID is required. Use --org-id flag or set AGENTUITY_CLOUD_ORG_ID.');
    }
    const adapter = createServerFetchAdapter({
        headers: {
            Authorization: `Bearer ${ctx.auth.apiKey}`,
            'x-agentuity-orgid': orgId,
        },
    }, ctx.logger);
    // Task tenant DB is not regional — any Catalyst can serve the request.
    const region = await getDefaultRegion(ctx.config?.name ?? defaultProfileName, ctx.config);
    const baseUrl = getCatalystUrl(region);
    return new TaskStorageService(baseUrl, adapter);
}
export async function cacheTaskId(ctx, taskId) {
    const profileName = ctx.config?.name ?? defaultProfileName;
    const region = await getDefaultRegion(profileName, ctx.config);
    const orgId = ctx.options.orgId ??
        (process.env.AGENTUITY_CLOUD_ORG_ID || ctx.config?.preferences?.orgId);
    await setResourceInfo('task', profileName, taskId, region, orgId);
}
export function parseMetadataFlag(raw) {
    if (!raw)
        return undefined;
    try {
        return JSON.parse(raw);
    }
    catch {
        tui.fatal('Invalid JSON for --metadata flag');
    }
}
//# sourceMappingURL=util.js.map