import { z } from 'zod';
import { EmailStorageService, type Logger } from '@agentuity/core';
import type { AuthData, Config, GlobalOptions } from '../../../types';
export type { EmailAddress, EmailDestination, EmailInbound, EmailOutbound, EmailAttachment, EmailSendParams, } from '@agentuity/core';
export interface EmailContext {
    logger: Logger;
    auth: AuthData;
    config: Config | null;
    options: GlobalOptions;
}
export declare function resolveEmailOrgId(ctx: EmailContext): string;
export declare const EmailAddressSchema: z.ZodObject<{
    id: z.ZodString;
    email: z.ZodString;
    project_id: z.ZodOptional<z.ZodString>;
    provider: z.ZodOptional<z.ZodString>;
    config: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    created_at: z.ZodString;
    updated_at: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
export declare function truncate(value: string | undefined, length?: number): string;
export declare function createEmailAdapter(ctx: EmailContext, region?: string): Promise<EmailStorageService>;
//# sourceMappingURL=util.d.ts.map