/**
 * DB import rewriting helpers for the Bun.build plugin.
 *
 * These functions rewrite `import { SQL } from 'bun'` → `@agentuity/postgres`
 * and `import { Pool } from 'pg'` → `@agentuity/postgres` so that
 * the Agentuity resilient postgres driver is bundled into the server output.
 */
/**
 * Map a file path to the appropriate Bun loader based on extension.
 */
export declare const getLoaderForPath: (filePath: string) => string;
/**
 * Split named import/export specifiers, moving the `targetName` specifier
 * to the `move` list while leaving everything else in `stay`.
 *
 * Type-only specifiers (prefixed with `type `) always stay.
 * Aliases (`SQL as Foo`) are matched on the import name, not the alias.
 */
export declare const rewriteNamedSpecifiers: (specifiers: string, targetName: string) => {
    stay: string[];
    move: string[];
    moved: boolean;
};
/**
 * Rewrite `import { SQL } from 'bun'` → `import { SQL } from '@agentuity/postgres'`.
 *
 * - Type-only imports (`import type { SQL }`) are left untouched.
 * - Inline type specifiers (`import { type SQL }`) are left untouched.
 * - Mixed imports are split: non-SQL specifiers stay with `'bun'`.
 * - Works with both single and double quotes, with or without semicolons.
 * - Preserves leading indentation.
 */
export declare const rewriteBunImports: (contents: string) => {
    contents: string;
    changed: boolean;
};
/**
 * Rewrite `import { Pool } from 'pg'` → `import { Pool } from '@agentuity/postgres'`.
 *
 * - Type-only imports (`import type { Pool }`) are left untouched.
 * - Namespace imports (`import * as pg`) are left untouched.
 * - Default imports (`import pg from 'pg'`) are left untouched.
 * - Mixed default+named imports are split correctly.
 * - Works with both `import` and `export` statements.
 */
export declare const rewritePgImports: (contents: string) => {
    contents: string;
    changed: boolean;
};
//# sourceMappingURL=db-rewrite.d.ts.map