import type { CommandContext, AuthData, Config } from './types';
import { type APIClient as APIClientType } from './api';
export declare function isTTY(): boolean;
export declare function hasPrefixedResourceId(args?: Record<string, unknown> | unknown[], opts?: Record<string, unknown> | unknown[]): boolean;
export declare function resolveOrgIdWithoutPrompt(ctx: {
    options: {
        orgId?: string;
    };
    config: Config | null;
    args?: Record<string, unknown> | unknown[];
    opts?: Record<string, unknown> | unknown[];
}): Promise<string | undefined>;
export declare function hasLoggedInBefore(): Promise<boolean>;
export declare function isAuthenticated(): Promise<boolean>;
export declare function requireAuth(ctx: CommandContext<undefined>): Promise<AuthData>;
export declare function optionalAuth(ctx: CommandContext<undefined>, continueText?: string, skipPrompts?: boolean): Promise<AuthData | null>;
export declare function requireOrg(ctx: CommandContext & {
    apiClient: APIClientType;
}, autoSelect?: boolean): Promise<string>;
export declare function optionalOrg(ctx: CommandContext & {
    apiClient?: APIClientType;
    auth?: AuthData;
}, autoSelect?: boolean): Promise<string | undefined>;
//# sourceMappingURL=auth.d.ts.map