import { useMemo } from 'react';
const getLogLevel = () => {
    try {
        const level = localStorage.getItem('AGENTUITY_LOG_LEVEL');
        if (level && ['debug', 'info', 'warn', 'error'].includes(level)) {
            return level;
        }
        return null;
    }
    catch {
        return null;
    }
};
const shouldLog = (messageLevel) => {
    const currentLevel = getLogLevel();
    if (!currentLevel)
        return false;
    const levels = {
        debug: 0,
        info: 1,
        warn: 2,
        error: 3,
    };
    return levels[messageLevel] >= levels[currentLevel];
};
export function useLogger(component) {
    // Memoize the entire logger object to prevent re-render loops
    // when logger is used as a dependency in useCallback/useEffect
    return useMemo(() => {
        const createLogFunction = (level) => (...args) => {
            if (!shouldLog(level)) {
                return;
            }
            const prefix = component ? `[${component}]` : '[Workbench]';
            const consoleFn = console[level] || console.log;
            consoleFn(prefix, ...args);
        };
        return {
            debug: createLogFunction('debug'),
            info: createLogFunction('info'),
            warn: createLogFunction('warn'),
            error: createLogFunction('error'),
        };
    }, [component]);
}
//# sourceMappingURL=useLogger.js.map