import { jsx as _jsx } from "react/jsx-runtime";
import { createContext, useContext, useEffect, useState } from 'react';
const initialState = {
    panelSizes: {},
    setPanelSizes: () => null,
    getPanelSizes: () => undefined,
    resetPanelSizes: () => null,
};
const ResizableProviderContext = createContext(initialState);
export function ResizableProvider({ children, storageKey = 'agentuity-workbench-panel-sizes', ...props }) {
    const [panelSizes, setPanelSizesState] = useState(() => {
        try {
            const stored = localStorage.getItem(storageKey);
            return stored ? JSON.parse(stored) : {};
        }
        catch {
            return {};
        }
    });
    useEffect(() => {
        localStorage.setItem(storageKey, JSON.stringify(panelSizes));
    }, [panelSizes, storageKey]);
    const value = {
        panelSizes,
        setPanelSizes: (groupId, sizes) => {
            const roundedSizes = sizes.map((size) => Math.round(size));
            setPanelSizesState((prev) => ({
                ...prev,
                [groupId]: roundedSizes,
            }));
        },
        getPanelSizes: (groupId) => panelSizes[groupId],
        resetPanelSizes: (groupId) => {
            if (groupId) {
                setPanelSizesState((prev) => {
                    const { [groupId]: _, ...rest } = prev;
                    return rest;
                });
            }
            else {
                setPanelSizesState({});
            }
        },
    };
    return (_jsx(ResizableProviderContext.Provider, { ...props, value: value, children: children }));
}
export const useResizable = () => {
    const context = useContext(ResizableProviderContext);
    if (context === undefined) {
        throw new Error('useResizable must be used within a ResizableProvider');
    }
    return context;
};
//# sourceMappingURL=resizable-provider.js.map