import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { cva } from 'class-variance-authority';
import { cn } from '../../lib/utils';
import { Avatar, AvatarFallback, AvatarImage } from '../ui/avatar';
export const Message = ({ className, from, ...props }) => (_jsx("div", { className: cn('group flex w-full items-end justify-end gap-2 py-4', from === 'user' ? 'is-user' : 'is-assistant flex-row-reverse justify-end', className), ...props }));
const messageContentVariants = cva('is-user:dark flex flex-col gap-2 overflow-hidden rounded-md text-sm', {
    variants: {
        variant: {
            contained: ['max-w-[80%] px-4 py-3 bg-input/30 text-foreground'],
            flat: [
                'group-[.is-user]:max-w-[80%] group-[.is-user]:bg-secondary group-[.is-user]:px-4 group-[.is-user]:py-3 group-[.is-user]:text-foreground',
            ],
        },
    },
    defaultVariants: {
        variant: 'contained',
    },
});
export const MessageContent = ({ children, className, variant, ...props }) => (_jsx("div", { className: cn(messageContentVariants({ variant, className })), ...props, children: children }));
export const MessageAvatar = ({ src, name, className, ...props }) => (_jsxs(Avatar, { className: cn('size-8 ring-1 ring-border', className), ...props, children: [_jsx(AvatarImage, { alt: "", className: "mt-0 mb-0", src: src }), _jsx(AvatarFallback, { children: name?.slice(0, 2) || 'ME' })] }));
//# sourceMappingURL=message.js.map