import type { FetchRequest, FetchResponse, FetchAdapter, Logger } from '@agentuity/core';
import { ServiceException } from '@agentuity/core';
interface ServiceAdapterConfig {
    headers: Record<string, string>;
    queryParams?: Record<string, string>;
    onBefore?: (url: string, options: FetchRequest, invoke: () => Promise<void>) => Promise<void>;
    onAfter?: <T>(url: string, options: FetchRequest, response: FetchResponse<T>, err?: InstanceType<typeof ServiceException>) => Promise<void>;
}
/**
 * Redacts the middle of a string while keeping a prefix and suffix visible.
 * Ensures that if the string is too short, everything is redacted.
 *
 * @param input The string to redact
 * @param prefix Number of chars to keep at the start
 * @param suffix Number of chars to keep at the end
 * @param mask  Character used for redaction
 */
export declare function redact(input: string, prefix?: number, suffix?: number, mask?: string): string;
declare class ServerFetchAdapter implements FetchAdapter {
    #private;
    constructor(config: ServiceAdapterConfig, logger: Logger);
    private _invoke;
    invoke<T>(url: string, options?: FetchRequest): Promise<FetchResponse<T>>;
}
/**
 * Create a Server Side Fetch Adapter to allow the server to add headers and track outgoing requests
 *
 * @param config the service config
 * @returns
 */
export declare function createServerFetchAdapter(config: ServiceAdapterConfig, logger: Logger): ServerFetchAdapter;
export {};
//# sourceMappingURL=server.d.ts.map