/**
 * Runtime environment bootstrapping utility
 *
 * Simplified bootstrap that sets up service URLs based on environment.
 * Does not depend on CLI config files or .env file parsing.
 */
export interface RuntimeBootstrapOptions {
    /**
     * Project directory (reserved for future use)
     * @default process.cwd()
     */
    projectDir?: string;
    /**
     * Override the active profile
     */
    profile?: string;
}
/**
 * Bootstrap runtime environment by setting service URLs.
 *
 * This function:
 * 1. Sets AGENTUITY_REGION=local for local/development environments
 * 2. Sets service URLs based on AGENTUITY_REGION
 * 3. Propagates profile name to environment
 *
 * Note: This does NOT load .env files. Use a proper .env loader
 * (like dotenv) in your app.ts before calling this function.
 *
 * Call this BEFORE createApp() in your app.ts:
 *
 * @example
 * ```ts
 * import { bootstrapRuntimeEnv } from '@agentuity/server';
 * import { createApp } from '@agentuity/runtime';
 *
 * // Set up service URLs
 * bootstrapRuntimeEnv();
 *
 * // Now createApp() will use the correct env vars
 * const app = await createApp();
 * ```
 */
export declare function bootstrapRuntimeEnv(options?: RuntimeBootstrapOptions): void;
//# sourceMappingURL=runtime-bootstrap.d.ts.map