import { z } from 'zod';
import { type APIClient } from '../api.ts';
import { type ListWebhookDeliveriesRequest, type WebhookApiOptions, type WebhookDelivery } from './types.ts';
export declare const WebhookDeliveryResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        id: z.ZodString;
        date: z.ZodString;
        webhook_id: z.ZodString;
        webhook_destination_id: z.ZodString;
        webhook_receipt_id: z.ZodString;
        status: z.ZodEnum<{
            success: "success";
            pending: "pending";
            failed: "failed";
        }>;
        retries: z.ZodNumber;
        error: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        response: z.ZodOptional<z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodUnknown>>>;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export declare const WebhookDeliveriesListResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodArray<z.ZodObject<{
        id: z.ZodString;
        date: z.ZodString;
        webhook_id: z.ZodString;
        webhook_destination_id: z.ZodString;
        webhook_receipt_id: z.ZodString;
        status: z.ZodEnum<{
            success: "success";
            pending: "pending";
            failed: "failed";
        }>;
        retries: z.ZodNumber;
        error: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        response: z.ZodOptional<z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodUnknown>>>;
    }, z.core.$strip>>;
}, z.core.$strip>], "success">;
/**
 * List deliveries for a webhook with optional pagination.
 *
 * Deliveries represent attempts to forward a received webhook payload to a destination.
 *
 * @param client - The API client instance
 * @param webhookId - The webhook ID (prefixed with wh_)
 * @param params - Optional pagination parameters
 * @param options - Optional API options (e.g., orgId)
 * @returns Object containing the list of deliveries
 * @throws {WebhookNotFoundError} If the webhook does not exist
 * @throws {WebhookError} If the API request fails
 *
 * @example
 * ```typescript
 * const { deliveries } = await listWebhookDeliveries(client, 'wh_abc123', { limit: 10 });
 * for (const delivery of deliveries) {
 *   console.log(`Delivery ${delivery.id}: ${delivery.status}`);
 * }
 * ```
 */
export declare function listWebhookDeliveries(client: APIClient, webhookId: string, params?: ListWebhookDeliveriesRequest, options?: WebhookApiOptions): Promise<{
    deliveries: WebhookDelivery[];
}>;
/**
 * Retry a failed webhook delivery.
 *
 * Re-attempts delivery of a webhook payload to the destination. This creates
 * a new delivery attempt for the same receipt and destination.
 *
 * @param client - The API client instance
 * @param webhookId - The webhook ID (prefixed with wh_)
 * @param deliveryId - The delivery ID to retry (prefixed with whdv_)
 * @param options - Optional API options (e.g., orgId)
 * @returns The new delivery attempt
 * @throws {WebhookDeliveryNotFoundError} If the delivery does not exist
 * @throws {WebhookNotFoundError} If the webhook does not exist
 * @throws {WebhookError} If the API request fails
 *
 * @example
 * ```typescript
 * const delivery = await retryWebhookDelivery(client, 'wh_abc123', 'whdv_def456');
 * console.log(`Retry delivery ${delivery.id}: ${delivery.status}`);
 * ```
 */
export declare function retryWebhookDelivery(client: APIClient, webhookId: string, deliveryId: string, options?: WebhookApiOptions): Promise<WebhookDelivery>;
//# sourceMappingURL=deliveries.d.ts.map