import { z } from 'zod';
import { APIClient } from '../api.ts';
import { type Thread } from './list.ts';
export declare const _ThreadGetRequestSchema: z.ZodObject<{
    id: z.ZodString;
}, z.core.$strip>;
export declare const ThreadGetResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        id: z.ZodString;
        created_at: z.ZodString;
        updated_at: z.ZodString;
        deleted: z.ZodBoolean;
        deleted_at: z.ZodNullable<z.ZodString>;
        deleted_by: z.ZodNullable<z.ZodString>;
        org_id: z.ZodString;
        project_id: z.ZodString;
        user_data: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        metadata: z.ZodOptional<z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodUnknown>>>;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export type ThreadGetRequest = z.infer<typeof _ThreadGetRequestSchema>;
export type ThreadGetResponse = z.infer<typeof ThreadGetResponseSchema>;
/**
 * Get a single thread by id
 *
 * @param client
 * @param request
 * @returns
 */
export declare function threadGet(client: APIClient, request: ThreadGetRequest): Promise<Thread>;
//# sourceMappingURL=get.d.ts.map