import { z } from 'zod';
import { APIResponseSchema } from "../api.js";
import { SessionResponseError } from "./util.js";
export const _SessionLogsRequestSchema = z.object({
    id: z.string().describe('the session id'),
});
export const LogSchema = z.object({
    body: z.string().describe('the log body'),
    severity: z.string().describe('the log severity'),
    timestamp: z.string().describe('the log timestamp'),
});
export const SessionLogsResponse = z.array(LogSchema);
export const SessionLogsResponseSchema = APIResponseSchema(SessionLogsResponse);
/**
 * Get logs for a session from the App API
 *
 * @param client APIClient configured for the App API base URL
 * @param request
 * @returns
 */
export async function sessionLogs(client, request) {
    const resp = await client.request('GET', `/cli/session/${request.id}/logs`, SessionLogsResponseSchema);
    if (resp.success) {
        return resp.data;
    }
    throw new SessionResponseError({ message: resp.message });
}
//# sourceMappingURL=logs.js.map