import type { ListRuntimesParams, ListRuntimesResponse } from '@agentuity/core';
import { z } from 'zod';
import { type APIClient } from '../api.ts';
export declare const RuntimeRequirementsSchema: z.ZodObject<{
    memory: z.ZodOptional<z.ZodString>;
    cpu: z.ZodOptional<z.ZodString>;
    disk: z.ZodOptional<z.ZodString>;
    networkEnabled: z.ZodBoolean;
}, z.core.$strip>;
export declare const RuntimeInfoSchema: z.ZodObject<{
    id: z.ZodString;
    name: z.ZodString;
    description: z.ZodOptional<z.ZodString>;
    iconUrl: z.ZodOptional<z.ZodString>;
    brandColor: z.ZodOptional<z.ZodString>;
    url: z.ZodOptional<z.ZodString>;
    tags: z.ZodOptional<z.ZodArray<z.ZodString>>;
    requirements: z.ZodOptional<z.ZodObject<{
        memory: z.ZodOptional<z.ZodString>;
        cpu: z.ZodOptional<z.ZodString>;
        disk: z.ZodOptional<z.ZodString>;
        networkEnabled: z.ZodBoolean;
    }, z.core.$strip>>;
    readme: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
export declare const ListRuntimesDataSchema: z.ZodObject<{
    runtimes: z.ZodArray<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        description: z.ZodOptional<z.ZodString>;
        iconUrl: z.ZodOptional<z.ZodString>;
        brandColor: z.ZodOptional<z.ZodString>;
        url: z.ZodOptional<z.ZodString>;
        tags: z.ZodOptional<z.ZodArray<z.ZodString>>;
        requirements: z.ZodOptional<z.ZodObject<{
            memory: z.ZodOptional<z.ZodString>;
            cpu: z.ZodOptional<z.ZodString>;
            disk: z.ZodOptional<z.ZodString>;
            networkEnabled: z.ZodBoolean;
        }, z.core.$strip>>;
        readme: z.ZodOptional<z.ZodString>;
    }, z.core.$strip>>;
    total: z.ZodNumber;
}, z.core.$strip>;
export declare const ListRuntimesResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        runtimes: z.ZodArray<z.ZodObject<{
            id: z.ZodString;
            name: z.ZodString;
            description: z.ZodOptional<z.ZodString>;
            iconUrl: z.ZodOptional<z.ZodString>;
            brandColor: z.ZodOptional<z.ZodString>;
            url: z.ZodOptional<z.ZodString>;
            tags: z.ZodOptional<z.ZodArray<z.ZodString>>;
            requirements: z.ZodOptional<z.ZodObject<{
                memory: z.ZodOptional<z.ZodString>;
                cpu: z.ZodOptional<z.ZodString>;
                disk: z.ZodOptional<z.ZodString>;
                networkEnabled: z.ZodBoolean;
            }, z.core.$strip>>;
            readme: z.ZodOptional<z.ZodString>;
        }, z.core.$strip>>;
        total: z.ZodNumber;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export interface RuntimeListParams extends ListRuntimesParams {
    orgId?: string;
}
/**
 * Lists available sandbox runtimes with optional pagination.
 *
 * @param client - The API client to use for the request
 * @param params - Optional parameters for pagination
 * @returns List of runtimes with total count
 * @throws {SandboxResponseError} If the request fails
 */
export declare function runtimeList(client: APIClient, params?: RuntimeListParams): Promise<ListRuntimesResponse>;
//# sourceMappingURL=runtime.d.ts.map