import { APIResponseSchemaNoData } from '../api';
import { API_VERSION, throwSandboxError } from './util';
export const PauseResponseSchema = APIResponseSchemaNoData();
/**
 * Pauses a running sandbox, creating a checkpoint of its current state.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters including the sandbox ID to pause
 * @throws {SandboxResponseError} If the sandbox is not found or pause fails
 */
export async function sandboxPause(client, params) {
    const { sandboxId, orgId } = params;
    const queryParams = new URLSearchParams();
    if (orgId) {
        queryParams.set('orgId', orgId);
    }
    const queryString = queryParams.toString();
    const url = `/sandbox/${API_VERSION}/${sandboxId}/pause${queryString ? `?${queryString}` : ''}`;
    const resp = await client.post(url, undefined, PauseResponseSchema);
    if (resp.success) {
        return;
    }
    throwSandboxError(resp, { sandboxId });
}
//# sourceMappingURL=pause.js.map