import type { ExecuteOptions, Execution } from '@agentuity/core';
import { z } from 'zod';
import { type APIClient } from '../api.ts';
export declare const ExecuteRequestSchema: z.ZodObject<{
    command: z.ZodArray<z.ZodString>;
    files: z.ZodOptional<z.ZodArray<z.ZodObject<{
        path: z.ZodString;
        content: z.ZodString;
    }, z.core.$strip>>>;
    timeout: z.ZodOptional<z.ZodString>;
    stream: z.ZodOptional<z.ZodObject<{
        stdout: z.ZodOptional<z.ZodString>;
        stderr: z.ZodOptional<z.ZodString>;
        timestamps: z.ZodOptional<z.ZodBoolean>;
    }, z.core.$strip>>;
}, z.core.$strip>;
export declare const ExecuteDataSchema: z.ZodObject<{
    executionId: z.ZodString;
    status: z.ZodEnum<{
        failed: "failed";
        completed: "completed";
        timeout: "timeout";
        running: "running";
        queued: "queued";
        cancelled: "cancelled";
    }>;
    exitCode: z.ZodOptional<z.ZodNumber>;
    durationMs: z.ZodOptional<z.ZodNumber>;
    stdoutStreamUrl: z.ZodOptional<z.ZodString>;
    stderrStreamUrl: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
export declare const ExecuteResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        executionId: z.ZodString;
        status: z.ZodEnum<{
            failed: "failed";
            completed: "completed";
            timeout: "timeout";
            running: "running";
            queued: "queued";
            cancelled: "cancelled";
        }>;
        exitCode: z.ZodOptional<z.ZodNumber>;
        durationMs: z.ZodOptional<z.ZodNumber>;
        stdoutStreamUrl: z.ZodOptional<z.ZodString>;
        stderrStreamUrl: z.ZodOptional<z.ZodString>;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export interface SandboxExecuteParams {
    sandboxId: string;
    options: ExecuteOptions;
    orgId?: string;
    signal?: AbortSignal;
}
/**
 * Executes a command in an existing sandbox.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters including sandbox ID and execution options
 * @returns The execution result including status and stream URLs
 * @throws {SandboxResponseError} If the execution request fails
 */
export declare function sandboxExecute(client: APIClient, params: SandboxExecuteParams): Promise<Execution>;
//# sourceMappingURL=execute.d.ts.map