import type { z } from 'zod';
import { type APIClient } from '../api.ts';
export declare const DestroyResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
}, z.core.$strip>], "success">;
export interface SandboxDestroyParams {
    sandboxId: string;
    orgId?: string;
}
/**
 * Destroys a sandbox and releases all associated resources.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters including the sandbox ID to destroy
 * @throws {SandboxResponseError} If the sandbox is not found or destruction fails
 */
export declare function sandboxDestroy(client: APIClient, params: SandboxDestroyParams): Promise<void>;
//# sourceMappingURL=destroy.d.ts.map