import { z } from 'zod';
import { APIResponseSchema } from "../api.js";
import { MalwareCheckError } from "./util.js";
export const PackageRefSchema = z.object({
    name: z.string(),
    version: z.string(),
});
export const MalwareFindingSchema = z.object({
    name: z.string(),
    version: z.string(),
    reason: z.string(),
});
export const MalwareCheckSummarySchema = z.object({
    scanned: z.number(),
    flagged: z.number(),
});
export const MalwareCheckListMetadataSchema = z.object({
    fetchedAt: z.string(),
    count: z.number(),
});
export const MalwareCheckResultSchema = z.object({
    action: z.enum(['allow', 'block']),
    summary: MalwareCheckSummarySchema,
    findings: z.array(MalwareFindingSchema),
    list: MalwareCheckListMetadataSchema.optional(),
    error: z.string().optional(),
});
export const MalwareCheckResponseSchema = APIResponseSchema(MalwareCheckResultSchema);
export async function projectDeploymentMalwareCheck(client, deploymentId, packages, signal) {
    const resp = await client.request('POST', `/security/2026-01-22/${deploymentId}/malware-check`, MalwareCheckResponseSchema, {
        ecosystem: 'npm',
        packages,
    }, undefined, signal);
    if (!resp.success) {
        throw new MalwareCheckError({
            message: resp.message || 'Malware check request failed',
            deploymentId,
        });
    }
    return resp.data;
}
//# sourceMappingURL=malware.js.map