import { z } from 'zod';
import { APIResponseSchema } from "../api.js";
import { ProjectResponseError } from "./util.js";
// --- GET hostname ---
export const ProjectHostnameGetRequestSchema = z.object({
    projectId: z.string().describe('the project id'),
});
const HostnameGetDataSchema = z.object({
    hostname: z.string().nullable(),
    url: z.string().nullable(),
});
const ProjectHostnameGetResponseSchema = APIResponseSchema(HostnameGetDataSchema);
export async function projectHostnameGet(client, request) {
    const resp = await client.get(`/cli/project/${request.projectId}/hostname`, ProjectHostnameGetResponseSchema);
    if (resp.success) {
        return resp.data;
    }
    throw new ProjectResponseError({ message: resp.message });
}
// --- SET hostname ---
export const ProjectHostnameSetRequestSchema = z.object({
    projectId: z.string().describe('the project id'),
    hostname: z.string().describe('the vanity hostname to set'),
});
const HostnameSetDataSchema = z.object({
    hostname: z.string(),
    url: z.string(),
});
const ProjectHostnameSetResponseSchema = APIResponseSchema(HostnameSetDataSchema);
export async function projectHostnameSet(client, request) {
    const resp = await client.put(`/cli/project/${request.projectId}/hostname`, { hostname: request.hostname }, ProjectHostnameSetResponseSchema);
    if (resp.success) {
        return resp.data;
    }
    throw new ProjectResponseError({ message: resp.message });
}
//# sourceMappingURL=hostname.js.map