import { z } from 'zod';
import { type APIClient } from '../api.ts';
export declare const ProjectEnvDeleteRequestSchema: z.ZodObject<{
    id: z.ZodString;
    env: z.ZodOptional<z.ZodArray<z.ZodString>>;
    secrets: z.ZodOptional<z.ZodArray<z.ZodString>>;
}, z.core.$strip>;
export declare const ProjectEnvDeleteResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
}, z.core.$strip>], "success">;
type ProjectEnvDeleteRequest = z.infer<typeof ProjectEnvDeleteRequestSchema>;
/**
 * Delete environment variables and/or secrets from a project.
 * Provide arrays of keys to delete.
 */
export declare function projectEnvDelete(client: APIClient, request: ProjectEnvDeleteRequest): Promise<void>;
export {};
//# sourceMappingURL=env-delete.d.ts.map