import { z } from 'zod';
import { APIResponseSchema } from "../api.js";
import { ProjectResponseError } from "./util.js";
export const ProjectDeleteRequestSchema = z.object({ ids: z.array(z.string()) });
export const ProjectDeleteResponseSchema = APIResponseSchema(z.array(z.string()));
export async function projectDelete(client, ...ids) {
    const resp = await client.request('DELETE', '/cli/project', ProjectDeleteResponseSchema, { ids }, ProjectDeleteRequestSchema);
    if (resp.success) {
        return resp.data;
    }
    throw new ProjectResponseError({ message: resp.message ?? 'failed to delete project' });
}
//# sourceMappingURL=delete.js.map