import { z } from 'zod';
import type { APIClient } from '../api.ts';
export declare const AgentSchema: z.ZodObject<{
    id: z.ZodString;
    name: z.ZodString;
    description: z.ZodNullable<z.ZodString>;
    identifier: z.ZodString;
    deploymentId: z.ZodNullable<z.ZodString>;
    devmode: z.ZodBoolean;
    metadata: z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    createdAt: z.ZodString;
    updatedAt: z.ZodString;
    evals: z.ZodArray<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        description: z.ZodNullable<z.ZodString>;
        identifier: z.ZodNullable<z.ZodString>;
        devmode: z.ZodBoolean;
        createdAt: z.ZodString;
        updatedAt: z.ZodString;
    }, z.core.$strip>>;
}, z.core.$strip>;
export declare const AgentListResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodArray<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        description: z.ZodNullable<z.ZodString>;
        identifier: z.ZodString;
        deploymentId: z.ZodNullable<z.ZodString>;
        devmode: z.ZodBoolean;
        metadata: z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        createdAt: z.ZodString;
        updatedAt: z.ZodString;
        evals: z.ZodArray<z.ZodObject<{
            id: z.ZodString;
            name: z.ZodString;
            description: z.ZodNullable<z.ZodString>;
            identifier: z.ZodNullable<z.ZodString>;
            devmode: z.ZodBoolean;
            createdAt: z.ZodString;
            updatedAt: z.ZodString;
        }, z.core.$strip>>;
    }, z.core.$strip>>;
}, z.core.$strip>], "success">;
export declare const AgentGetResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodArray<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        description: z.ZodNullable<z.ZodString>;
        identifier: z.ZodString;
        deploymentId: z.ZodNullable<z.ZodString>;
        devmode: z.ZodBoolean;
        metadata: z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        createdAt: z.ZodString;
        updatedAt: z.ZodString;
        evals: z.ZodArray<z.ZodObject<{
            id: z.ZodString;
            name: z.ZodString;
            description: z.ZodNullable<z.ZodString>;
            identifier: z.ZodNullable<z.ZodString>;
            devmode: z.ZodBoolean;
            createdAt: z.ZodString;
            updatedAt: z.ZodString;
        }, z.core.$strip>>;
    }, z.core.$strip>>;
}, z.core.$strip>], "success">;
export type Agent = z.infer<typeof AgentSchema>;
/**
 * List agents for a project
 */
export declare function projectAgentList(client: APIClient, projectId: string, options?: {
    deploymentId?: string;
    orgId?: string;
}): Promise<Agent[]>;
/**
 * Get a specific agent by identifier
 */
export declare function projectAgentGet(client: APIClient, projectId: string, agentId: string): Promise<Agent>;
//# sourceMappingURL=agent.d.ts.map