import { z } from 'zod';
import { APIClient } from '../api.ts';
export declare const ListOrganizationsResponse: z.ZodArray<z.ZodObject<{
    id: z.ZodString;
    name: z.ZodString;
}, z.core.$strip>>;
export declare const ListOrganizationsResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodArray<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
    }, z.core.$strip>>;
}, z.core.$strip>], "success">;
export type ListOrganizationsResponse = z.infer<typeof ListOrganizationsResponseSchema>;
export type OrganizationList = z.infer<typeof ListOrganizationsResponse>;
/**
 * List all organizations
 *
 * @param client
 * @returns
 */
export declare function listOrganizations(client: APIClient): Promise<OrganizationList>;
//# sourceMappingURL=list.d.ts.map