import { z } from 'zod';
import { APIResponseSchemaNoData } from "../api.js";
import { OrgResponseError } from "./util.js";
export const OrgEnvUpdateRequestSchema = z.object({
    id: z.string().describe('the organization id'),
    env: z.record(z.string(), z.string()).optional().describe('environment variables to set/update'),
    secrets: z.record(z.string(), z.string()).optional().describe('secrets to set/update'),
});
export const OrgEnvUpdateResponseSchema = APIResponseSchemaNoData();
/**
 * Update environment variables and/or secrets for an organization.
 * This will merge the provided env/secrets with existing values.
 * Requires admin/owner role.
 * Keys starting with 'AGENTUITY_' (except AGENTUITY_PUBLIC_) are filtered out.
 */
export async function orgEnvUpdate(client, request) {
    const { id, env, secrets } = request;
    const resp = await client.request('PUT', `/cli/organization/${id}/env`, OrgEnvUpdateResponseSchema, {
        env,
        secrets,
    });
    if (!resp.success) {
        throw new OrgResponseError({ message: resp.message ?? 'failed to update org env' });
    }
}
//# sourceMappingURL=env-update.js.map