import { z } from 'zod';
import { APIClient } from '../api.ts';
export declare const MachineSchema: z.ZodObject<{
    id: z.ZodString;
    instanceId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    privateIPv4: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    availabilityZone: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    instanceType: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    instanceTags: z.ZodOptional<z.ZodNullable<z.ZodArray<z.ZodString>>>;
    deploymentCount: z.ZodOptional<z.ZodNumber>;
    status: z.ZodString;
    provider: z.ZodString;
    region: z.ZodString;
    startedAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    stoppedAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    pausedAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    erroredAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    error: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    orgId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    orgName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    createdAt: z.ZodString;
    updatedAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    metadata: z.ZodOptional<z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodUnknown>>>;
}, z.core.$strip>;
export declare const MachineListResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodArray<z.ZodObject<{
        id: z.ZodString;
        instanceId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        privateIPv4: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        availabilityZone: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        instanceType: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        instanceTags: z.ZodOptional<z.ZodNullable<z.ZodArray<z.ZodString>>>;
        deploymentCount: z.ZodOptional<z.ZodNumber>;
        status: z.ZodString;
        provider: z.ZodString;
        region: z.ZodString;
        startedAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        stoppedAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        pausedAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        erroredAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        error: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        orgId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        orgName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        createdAt: z.ZodString;
        updatedAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        metadata: z.ZodOptional<z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodUnknown>>>;
    }, z.core.$strip>>;
}, z.core.$strip>], "success">;
export declare const MachineGetResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        id: z.ZodString;
        instanceId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        privateIPv4: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        availabilityZone: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        instanceType: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        instanceTags: z.ZodOptional<z.ZodNullable<z.ZodArray<z.ZodString>>>;
        deploymentCount: z.ZodOptional<z.ZodNumber>;
        status: z.ZodString;
        provider: z.ZodString;
        region: z.ZodString;
        startedAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        stoppedAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        pausedAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        erroredAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        error: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        orgId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        orgName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        createdAt: z.ZodString;
        updatedAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        metadata: z.ZodOptional<z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodUnknown>>>;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export declare const MachineDeleteResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
}, z.core.$strip>], "success">;
export type Machine = z.infer<typeof MachineSchema>;
export declare function machineList(client: APIClient, options?: {
    orgId?: string;
}): Promise<Machine[]>;
export declare function machineGet(client: APIClient, machineId: string): Promise<Machine>;
export declare function machineDelete(client: APIClient, machineId: string): Promise<void>;
export declare const MachineDeploymentProjectSchema: z.ZodObject<{
    id: z.ZodString;
    name: z.ZodString;
    identifier: z.ZodString;
    domains: z.ZodArray<z.ZodString>;
}, z.core.$strip>;
export type MachineDeploymentProject = z.infer<typeof MachineDeploymentProjectSchema>;
export declare const MachineDeploymentResourcesSchema: z.ZodObject<{
    cpuUnits: z.ZodNumber;
    memoryUnits: z.ZodNumber;
    diskUnits: z.ZodNumber;
}, z.core.$strip>;
export type MachineDeploymentResources = z.infer<typeof MachineDeploymentResourcesSchema>;
export declare const MachineDeploymentSchema: z.ZodObject<{
    id: z.ZodString;
    identifier: z.ZodOptional<z.ZodString>;
    state: z.ZodOptional<z.ZodString>;
    project: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        identifier: z.ZodString;
        domains: z.ZodArray<z.ZodString>;
    }, z.core.$strip>>>;
    resources: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        cpuUnits: z.ZodNumber;
        memoryUnits: z.ZodNumber;
        diskUnits: z.ZodNumber;
    }, z.core.$strip>>>;
    customDomains: z.ZodArray<z.ZodString>;
    paused: z.ZodBoolean;
    pausedDuration: z.ZodNumber;
    domainSuffix: z.ZodString;
}, z.core.$strip>;
export declare const MachineDeploymentsResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodArray<z.ZodObject<{
        id: z.ZodString;
        identifier: z.ZodOptional<z.ZodString>;
        state: z.ZodOptional<z.ZodString>;
        project: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            id: z.ZodString;
            name: z.ZodString;
            identifier: z.ZodString;
            domains: z.ZodArray<z.ZodString>;
        }, z.core.$strip>>>;
        resources: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            cpuUnits: z.ZodNumber;
            memoryUnits: z.ZodNumber;
            diskUnits: z.ZodNumber;
        }, z.core.$strip>>>;
        customDomains: z.ZodArray<z.ZodString>;
        paused: z.ZodBoolean;
        pausedDuration: z.ZodNumber;
        domainSuffix: z.ZodString;
    }, z.core.$strip>>;
}, z.core.$strip>], "success">;
export type MachineDeployment = z.infer<typeof MachineDeploymentSchema>;
export declare function machineDeployments(client: APIClient, machineId: string): Promise<MachineDeployment[]>;
export declare const OrgAuthEnrollResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        orgId: z.ZodString;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export declare function orgAuthEnroll(client: APIClient, orgId: string, publicKey: string): Promise<{
    orgId: string;
}>;
export declare const OrgAuthStatusResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        publicKey: z.ZodNullable<z.ZodString>;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export declare function orgAuthStatus(client: APIClient, orgId: string): Promise<{
    publicKey: string | null;
}>;
export declare const OrgAuthUnenrollResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
}, z.core.$strip>], "success">;
export declare function orgAuthUnenroll(client: APIClient, orgId: string): Promise<void>;
//# sourceMappingURL=machine.d.ts.map