import { z } from 'zod';
import { type APIClient } from '../api.ts';
export declare const EvalRunSchema: z.ZodObject<{
    id: z.ZodString;
    sessionId: z.ZodString;
    evalId: z.ZodString;
    evalIdentifier: z.ZodNullable<z.ZodString>;
    evalName: z.ZodNullable<z.ZodString>;
    agentIdentifier: z.ZodNullable<z.ZodString>;
    projectId: z.ZodString;
    deploymentId: z.ZodNullable<z.ZodString>;
    devmode: z.ZodBoolean;
    pending: z.ZodBoolean;
    success: z.ZodBoolean;
    error: z.ZodNullable<z.ZodString>;
    result: z.ZodNullable<z.ZodAny>;
    createdAt: z.ZodString;
    updatedAt: z.ZodString;
}, z.core.$strip>;
export declare const EvalRunListResponseData: z.ZodArray<z.ZodObject<{
    id: z.ZodString;
    sessionId: z.ZodString;
    evalId: z.ZodString;
    evalIdentifier: z.ZodNullable<z.ZodString>;
    evalName: z.ZodNullable<z.ZodString>;
    agentIdentifier: z.ZodNullable<z.ZodString>;
    projectId: z.ZodString;
    deploymentId: z.ZodNullable<z.ZodString>;
    devmode: z.ZodBoolean;
    pending: z.ZodBoolean;
    success: z.ZodBoolean;
    error: z.ZodNullable<z.ZodString>;
    result: z.ZodNullable<z.ZodAny>;
    createdAt: z.ZodString;
    updatedAt: z.ZodString;
}, z.core.$strip>>;
export declare const EvalRunListResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodArray<z.ZodObject<{
        id: z.ZodString;
        sessionId: z.ZodString;
        evalId: z.ZodString;
        evalIdentifier: z.ZodNullable<z.ZodString>;
        evalName: z.ZodNullable<z.ZodString>;
        agentIdentifier: z.ZodNullable<z.ZodString>;
        projectId: z.ZodString;
        deploymentId: z.ZodNullable<z.ZodString>;
        devmode: z.ZodBoolean;
        pending: z.ZodBoolean;
        success: z.ZodBoolean;
        error: z.ZodNullable<z.ZodString>;
        result: z.ZodNullable<z.ZodAny>;
        createdAt: z.ZodString;
        updatedAt: z.ZodString;
    }, z.core.$strip>>;
}, z.core.$strip>], "success">;
export type EvalRunListItem = z.infer<typeof EvalRunSchema>;
export type EvalRunListRequest = {
    projectId?: string;
    agentId?: string;
    evalId?: string;
    sessionId?: string;
    orgId?: string;
};
export declare function evalRunList(client: APIClient, request?: EvalRunListRequest): Promise<EvalRunListItem[]>;
//# sourceMappingURL=run-list.d.ts.map