import { z } from 'zod';
import { APIClient } from '../api.ts';
export declare const APIKeyCreateResponseSchema: z.ZodObject<{
    id: z.ZodString;
    value: z.ZodString;
}, z.core.$strip>;
export declare const APIKeyCreateFullResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        id: z.ZodString;
        value: z.ZodString;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export type APIKeyCreateResponse = z.infer<typeof APIKeyCreateResponseSchema>;
export interface APIKeyCreateRequest {
    name: string;
    expiresAt: string;
    projectId?: string | null;
    orgId?: string | null;
}
/**
 * Create a new API key
 *
 * @param client
 * @param request the API key creation request
 * @returns
 */
export declare function apikeyCreate(client: APIClient, request: APIKeyCreateRequest): Promise<APIKeyCreateResponse>;
//# sourceMappingURL=create.d.ts.map