import type { Schema, Infer } from '../base.ts';
import { SCHEMA_KIND } from '../base.ts';
/**
 * Schema for nullable values (T | null).
 * Accepts null or the wrapped schema's type.
 *
 * @template T - The wrapped schema type
 *
 * @example
 * ```typescript
 * const schema = s.nullable(s.string());
 * schema.parse('hello'); // 'hello'
 * schema.parse(null); // null
 * schema.parse(123); // throws ValidationError
 * ```
 */
export declare class NullableSchema<T extends Schema<any, any>> implements Schema<Infer<T> | null, Infer<T> | null> {
    readonly [SCHEMA_KIND] = "NullableSchema";
    readonly schema: T;
    description?: string;
    readonly '~standard': {
        version: 1;
        vendor: string;
        validate: (value: unknown) => import("@agentuity/core").StandardSchemaV1.Result<any> | Promise<import("@agentuity/core").StandardSchemaV1.Result<any>>;
        types: {
            input: Infer<T> | null;
            output: Infer<T> | null;
        };
    };
    private parseMethods;
    constructor(schema: T);
    describe(description: string): this;
    optional(): Schema<Infer<T> | null | undefined, Infer<T> | null | undefined>;
    nullable(): this;
    parse: (this: Schema<any, Infer<T> | null>, value: unknown) => Infer<T> | null;
    safeParse: (this: Schema<any, Infer<T> | null>, value: unknown) => import("../base.ts").SafeParseResult<Infer<T> | null>;
}
/**
 * Make a schema nullable (T | null).
 *
 * @param schema - The schema to make nullable
 *
 * @example
 * ```typescript
 * const userSchema = s.object({
 *   name: s.string(),
 *   bio: s.nullable(s.string())
 * });
 * ```
 */
export declare function nullable<T extends Schema<any, any>>(schema: T): NullableSchema<T>;
//# sourceMappingURL=nullable.d.ts.map