import type { Schema } from '../base.ts';
import { SCHEMA_KIND } from '../base.ts';
/**
 * Schema for validating exact literal values.
 *
 * @template T - The exact value type
 *
 * @example
 * ```typescript
 * const adminSchema = s.literal('admin');
 * adminSchema.parse('admin'); // 'admin'
 * adminSchema.parse('user'); // throws ValidationError
 * ```
 */
export declare class LiteralSchema<T extends string | number | boolean> implements Schema<T, T> {
    private value;
    readonly [SCHEMA_KIND] = "LiteralSchema";
    description?: string;
    private parseMethods;
    constructor(value: T);
    readonly '~standard': {
        version: 1;
        vendor: string;
        validate: (input: unknown) => import("@agentuity/core").StandardSchemaV1.FailureResult | import("@agentuity/core").StandardSchemaV1.SuccessResult<T>;
        types: {
            input: T;
            output: T;
        };
    };
    describe(description: string): this;
    optional(): import("../index.ts").OptionalSchema<this>;
    nullable(): import("../index.ts").NullableSchema<this>;
    parse: (this: Schema<any, T>, value: unknown) => T;
    safeParse: (this: Schema<any, T>, value: unknown) => import("../base.ts").SafeParseResult<T>;
}
/**
 * Create a schema for an exact literal value.
 *
 * @param value - The exact value to match
 *
 * @example
 * ```typescript
 * const adminRole = s.literal('admin');
 * const maxValue = s.literal(100);
 * const enabled = s.literal(true);
 * ```
 */
export declare function literal<T extends string | number | boolean>(value: T): LiteralSchema<T>;
//# sourceMappingURL=literal.d.ts.map