import type { Schema } from '../base.ts';
import { SCHEMA_KIND } from '../base.ts';
/**
 * Schema that accepts any value with type-safe unknown.
 * Returns the value as-is without validation.
 * Use this when you want to accept any value but force type checking at usage site.
 *
 * @example
 * ```typescript
 * const schema = s.unknown();
 * const value = schema.parse(123); // unknown
 * const value2 = schema.parse('hello'); // unknown
 * const value3 = schema.parse(null); // unknown
 *
 * // Forces type narrowing
 * if (typeof value === 'string') {
 *   console.log(value.toUpperCase());
 * }
 * ```
 */
export declare class UnknownSchema implements Schema<unknown, unknown> {
    readonly [SCHEMA_KIND] = "UnknownSchema";
    description?: string;
    readonly '~standard': {
        version: 1;
        vendor: string;
        validate: (value: unknown) => import("@agentuity/core").StandardSchemaV1.SuccessResult<unknown>;
        types: {
            input: unknown;
            output: unknown;
        };
    };
    describe(description: string): this;
    optional(): import("../index.ts").OptionalSchema<this>;
    nullable(): import("../index.ts").NullableSchema<this>;
    parse: (this: Schema<any, unknown>, value: unknown) => unknown;
    safeParse: (this: Schema<any, unknown>, value: unknown) => import("../base.ts").SafeParseResult<unknown>;
}
/**
 * Create an unknown schema that accepts any value.
 *
 * @example
 * ```typescript
 * const schema = s.unknown();
 * const value = schema.parse(anything); // Type is unknown
 * ```
 */
export declare function unknown(): UnknownSchema;
//# sourceMappingURL=unknown.d.ts.map