import type { Schema } from '../base.ts';
import { SCHEMA_KIND } from '../base.ts';
/**
 * Schema that coerces any value to a string using String(value).
 *
 * @example
 * ```typescript
 * const schema = s.coerce.string();
 * schema.parse(123); // '123'
 * schema.parse(true); // 'true'
 * schema.parse(null); // 'null'
 * ```
 */
export declare class CoerceStringSchema implements Schema<unknown, string> {
    readonly [SCHEMA_KIND] = "CoerceStringSchema";
    description?: string;
    readonly '~standard': {
        version: 1;
        vendor: string;
        validate: (value: unknown) => import("@agentuity/core").StandardSchemaV1.SuccessResult<string>;
        types: {
            input: unknown;
            output: string;
        };
    };
    describe(description: string): this;
    optional(): import("../index.ts").OptionalSchema<this>;
    nullable(): import("../index.ts").NullableSchema<this>;
    parse: (this: Schema<any, string>, value: unknown) => string;
    safeParse: (this: Schema<any, string>, value: unknown) => import("../base.ts").SafeParseResult<string>;
}
/**
 * Create a schema that coerces values to strings.
 * Useful for parsing form data or query parameters.
 */
export declare function coerceString(): CoerceStringSchema;
//# sourceMappingURL=string.d.ts.map