import type { Schema } from '../base.ts';
import { SCHEMA_KIND } from '../base.ts';
/**
 * Schema that coerces values to Date objects using new Date(value).
 * Fails if the result is an invalid date.
 *
 * @example
 * ```typescript
 * const schema = s.coerce.date();
 * schema.parse('2025-01-01'); // Date object
 * schema.parse(1609459200000); // Date from timestamp
 * schema.parse('invalid'); // throws ValidationError
 * ```
 */
export declare class CoerceDateSchema implements Schema<unknown, Date> {
    readonly [SCHEMA_KIND] = "CoerceDateSchema";
    description?: string;
    readonly '~standard': {
        version: 1;
        vendor: string;
        validate: (value: unknown) => import("@agentuity/core").StandardSchemaV1.FailureResult | import("@agentuity/core").StandardSchemaV1.SuccessResult<Date>;
        types: {
            input: unknown;
            output: Date;
        };
    };
    describe(description: string): this;
    optional(): import("../index.ts").OptionalSchema<this>;
    nullable(): import("../index.ts").NullableSchema<this>;
    parse: (this: Schema<any, Date>, value: unknown) => Date;
    safeParse: (this: Schema<any, Date>, value: unknown) => import("../base.ts").SafeParseResult<Date>;
}
/**
 * Create a schema that coerces values to Date objects.
 * Useful for parsing ISO date strings or timestamps.
 */
export declare function coerceDate(): CoerceDateSchema;
//# sourceMappingURL=date.d.ts.map