import { APIClient } from '@agentuity/server';
import type { SandboxService, Sandbox, SandboxInfo, SandboxCreateOptions, SandboxRunOptions, SandboxRunResult, ListSandboxesParams, ListSandboxesResponse, SnapshotService } from '@agentuity/core';
/**
 * HTTP implementation of the SandboxService interface
 */
export declare class HTTPSandboxService implements SandboxService {
    private client;
    private streamBaseUrl;
    /**
     * Snapshot management operations
     */
    readonly snapshot: SnapshotService;
    constructor(client: APIClient, streamBaseUrl: string);
    run(options: SandboxRunOptions): Promise<SandboxRunResult>;
    create(options?: SandboxCreateOptions): Promise<Sandbox>;
    get(sandboxId: string): Promise<SandboxInfo>;
    list(params?: ListSandboxesParams): Promise<ListSandboxesResponse>;
    destroy(sandboxId: string): Promise<void>;
}
//# sourceMappingURL=http.d.ts.map