import type { Database } from 'bun:sqlite';
import type { KeyValueStorage, DataResult, KeyValueStorageSetParams, KeyValueStats, KeyValueItemWithMetadata, CreateNamespaceParams, GetAllStatsParams, KeyValueStatsPaginated } from '@agentuity/core';
export declare class LocalKeyValueStorage implements KeyValueStorage {
    #private;
    constructor(db: Database, projectPath: string);
    get<T>(name: string, key: string): Promise<DataResult<T>>;
    set<T = unknown>(name: string, key: string, value: T, params?: KeyValueStorageSetParams): Promise<void>;
    delete(name: string, key: string): Promise<void>;
    getStats(_name: string): Promise<KeyValueStats>;
    getAllStats(_params?: GetAllStatsParams): Promise<Record<string, KeyValueStats> | KeyValueStatsPaginated>;
    getNamespaces(): Promise<string[]>;
    search<T = unknown>(_name: string, _keyword: string): Promise<Record<string, KeyValueItemWithMetadata<T>>>;
    getKeys(_name: string): Promise<string[]>;
    deleteNamespace(_name: string): Promise<void>;
    createNamespace(_name: string, _params?: CreateNamespaceParams): Promise<void>;
}
//# sourceMappingURL=keyvalue.d.ts.map