/**
 * An implementation of the EvalRunEventProvider which writes to JSON files
 */
export class JSONEvalRunEventProvider {
    exportDir;
    constructor(exportDir) {
        this.exportDir = exportDir;
    }
    /**
     * called when the eval run starts
     *
     * @param event EvalRunStartEvent
     */
    async start(event) {
        const data = {
            type: 'evalrun_start',
            timestamp: Date.now(),
            ...event,
        };
        const filename = `${this.exportDir}/evalrun-${event.id}-start.json`;
        await Bun.write(filename, JSON.stringify(data, null, 2));
    }
    /**
     * called when the eval run completes
     *
     * @param event EvalRunCompleteEvent
     */
    async complete(event) {
        const data = {
            type: 'evalrun_complete',
            timestamp: Date.now(),
            ...event,
        };
        const filename = `${this.exportDir}/evalrun-${event.id}-complete.json`;
        await Bun.write(filename, JSON.stringify(data, null, 2));
    }
}
//# sourceMappingURL=json.js.map