export { type AgentContext, type AgentEventName, type AgentEventCallback, type AgentRuntimeState, type CreateEvalConfig, type AgentValidator, type Agent, type CreateAgentConfig, type AgentRunner, getGlobalRuntimeState, getAgentRuntime, type AgentName, type AgentRegistry, registerAgent, setAgentConfig, getAgentConfig, type CreateAgentConfigExplicit, createAgent, populateAgentsRegistry, createAgentMiddleware, getAgents, runAgentSetups, runAgentShutdowns, runInAgentContext, } from './agent';
export { type AppConfig, type CompressionConfig, type CorsConfig, type Variables, type TriggerType, type PrivateVariables, type Env, type AppResult, type ShutdownHook, createApp, getApp, getAppState, getAppConfig, runShutdown, registerShutdownHook, fireEvent, } from './app';
export { createTrustedCorsOrigin, type TrustedCorsOriginOptions } from './cors';
export { addEventListener, removeEventListener } from './_events';
export { createBaseMiddleware, createCorsMiddleware, createOtelMiddleware, createCompressionMiddleware, createWebSessionMiddleware, getSessionSecret, } from './middleware';
export { register } from './otel/config';
export { createServices } from './_services';
export { enableProcessExitProtection } from './_process-protection';
export { BEACON_SCRIPT, validateBeaconScript } from '@agentuity/frontend';
export { internalExit } from './_process-protection';
export { registerDevModeRoutes } from './devmode';
export { type HonoEnv, type WebSocketConnection, createRouter } from './router';
export { websocket, type WebSocketHandler, sse, type SSEMessage, type SSEStream, type SSEHandler, type SSEOptions, stream, type StreamHandler, cron, type CronHandler, type CronMetadata, webrtc, type WebRTCHandler, } from './handlers';
export { type SignalMessage, type SDPDescription, type ICECandidate, type WebRTCOptions, type WebRTCSignalingCallbacks, WebRTCRoomManager, } from './webrtc-signaling';
export { EvalHandlerResultSchema, type EvalContext, type EvalRunResultMetadata, type EvalHandlerResult, type EvalRunResultSuccess, type EvalRunResultError, type EvalRunResult, type CreateEvalRunRequest, type ExternalEvalMetadata, type EvalMetadata, type EvalFunction, type Eval, } from './eval';
export { type ThreadEventName, type SessionEventName, type ThreadState, type MergeOperation, type Thread, type Session, type ThreadIDProvider, type ThreadProvider, type SessionProvider, generateId, DefaultThreadIDProvider, DefaultThread, LazyThreadState, } from './session';
export { LocalThreadProvider } from './services/thread/local';
export { createWorkbenchExecutionRoute, createWorkbenchRouter, createWorkbenchMetadataRoute, createWorkbenchWebsocketRoute, } from './workbench';
export { createWebRouter } from './web';
export { type RouteValidator, validator } from './validator';
export type { Logger } from './logger';
export { getRouter, setGlobalRouter, createLogger, getLogger, setGlobalLogger, getTracer, setGlobalTracer, addSpanProcessor, getSpanProcessors, privateContext, notifyReady, getServer, AGENT_CONTEXT_PROPERTIES, } from './_server';
export { hasWaitUntilPending } from './_waituntil';
export { inAgentContext, inHTTPContext, getAgentContext, getHTTPContext } from './_context';
export { createAgentContext, StandaloneAgentContext, type StandaloneContextOptions, type InvokeOptions, } from './_standalone';
export { HTTPEvalRunEventProvider, LocalEvalRunEventProvider, JSONEvalRunEventProvider, CompositeEvalRunEventProvider, } from './services/evalrun';
export { loadBuildMetadata } from './_metadata';
export { getOrganizationId, getProjectId, getDeploymentId, isDevMode, isProduction, isInsideAgentRuntime, } from './_config';
export { getEvalRunEventProvider, getThreadProvider, getSessionProvider } from './_services';
export type { RouteSchema, GetRouteSchema } from './_validation';
/**
 * Application state interface that gets automatically augmented based on your createApp setup function.
 *
 * This interface is empty by default but gets populated with strongly-typed properties
 * when you define a setup function in createApp(). The Agentuity build tool automatically
 * generates type augmentations in `.agentuity/.agentuity_runtime.ts`.
 *
 * **How it works:**
 * 1. You define setup() in createApp() that returns an object
 * 2. The build tool generates module augmentation for this interface
 * 3. All agents get strongly-typed access to app state via `ctx.app`
 *
 * @example
 * ```typescript
 * // In your app.ts:
 * const app = await createApp({
 *   setup: async () => {
 *     const db = await connectDatabase();
 *     const redis = await connectRedis();
 *     return { db, redis };
 *   }
 * });
 *
 * // In your agent:
 * const agent = createAgent('user-query', {
 *   handler: async (ctx, input) => {
 *     // ctx.app is strongly typed with { db, redis }!
 *     const user = await ctx.app.db.query('SELECT * FROM users');
 *     await ctx.app.redis.set('key', 'value');
 *     return user;
 *   }
 * });
 * ```
 *
 * **Note:** If you're not seeing type hints for `ctx.app`, make sure you've run `bun run build`
 * to generate the type augmentations.
 */
export interface AppState {
}
export { bootstrapRuntimeEnv, type RuntimeBootstrapOptions, mimeTypes } from '@agentuity/server';
export { patchBunS3ForStorageDev, isAgentuityStorageEndpoint } from './bun-s3-patch';
//# sourceMappingURL=index.d.ts.map