import { z } from 'zod';
export const EvalHandlerResultSchema = z.object({
    passed: z.boolean(),
    score: z.number().min(0).max(1).optional(),
    reason: z.string().optional(),
    metadata: z.record(z.string(), z.any()).optional(),
});
// Internal types for catalyst (include success field)
export const EvalRunResultSuccessSchema = z.object({
    success: z.literal(true),
    passed: z.boolean(),
    score: z.number().min(0).max(1).optional(),
    reason: z.string().optional(),
    metadata: z.record(z.string(), z.any()).optional(),
});
//# sourceMappingURL=eval.js.map