import { ScheduleService, type KeyValueStorage, type StreamStorage, type VectorStorage, type SandboxService, type QueueService, type TaskStorage, type Logger, type SessionEventProvider, type EvalRunEventProvider } from '@agentuity/core';
import type { AppConfig } from './app';
import { type ThreadProvider, type SessionProvider } from './session';
export declare function createServices(logger: Logger, config?: AppConfig<any>, serverUrl?: string): {
    localRouter: any;
} | {
    localRouter?: undefined;
};
export declare function getThreadProvider(): ThreadProvider;
export declare function getSessionProvider(): SessionProvider;
export declare function getLocalRouter(): any | null;
export declare function getSessionEventProvider(): SessionEventProvider;
export declare function getEvalRunEventProvider(): EvalRunEventProvider;
export declare function getServices(): {
    kv: KeyValueStorage;
    stream: StreamStorage;
    vector: VectorStorage;
    sandbox: SandboxService;
    queue: QueueService;
    schedule: ScheduleService;
    task: TaskStorage;
};
export declare function registerServices(o: any, includeAgents?: boolean): void;
//# sourceMappingURL=_services.d.ts.map