import { AsyncLocalStorage } from 'node:async_hooks';
import type { Context as HonoContext } from 'hono';
import type { Tracer } from '@opentelemetry/api';
import { type KeyValueStorage, type StreamStorage, type VectorStorage, type SandboxService, type QueueService, type ScheduleService, type TaskStorage } from '@agentuity/core';
import type { AuthInterface } from '@agentuity/auth';
import type { AgentContext, AgentRegistry, AgentRunner, AgentRuntimeState, AgentMetadata } from './agent';
import { AGENT_RUNTIME } from './_config';
import type { Logger } from './logger';
import type WaitUntilHandler from './_waituntil';
import type { Thread, Session } from './session';
export interface RequestAgentContextArgs<TAgentMap extends AgentRegistry = AgentRegistry, TConfig = unknown, TAppState = Record<string, never>> {
    sessionId: string;
    agent: TAgentMap;
    logger: Logger;
    tracer: Tracer;
    session: Session;
    thread: Thread;
    handler: WaitUntilHandler;
    config: TConfig;
    app: TAppState;
    runtime: AgentRuntimeState;
    auth?: AuthInterface | null;
}
export declare class RequestAgentContext<TAgentMap extends AgentRegistry = AgentRegistry, TConfig = unknown, TAppState = Record<string, never>> implements AgentContext<TAgentMap, TConfig, TAppState> {
    agent: TAgentMap;
    logger: Logger;
    sessionId: string;
    tracer: Tracer;
    kv: KeyValueStorage;
    stream: StreamStorage;
    vector: VectorStorage;
    sandbox: SandboxService;
    queue: QueueService;
    schedule: ScheduleService;
    task: TaskStorage;
    state: Map<string, unknown>;
    session: Session;
    thread: Thread;
    config: TConfig;
    app: TAppState;
    current: AgentMetadata;
    [AGENT_RUNTIME]: AgentRuntimeState;
    private handler;
    /**
     * Fallback auth value for non-HTTP contexts (standalone, tests, etc.)
     * @internal
     */
    private _initialAuth;
    /**
     * Authentication context - lazily reads from HTTP context if available.
     *
     * This is a getter that prefers the current HTTP context's `c.var.auth`,
     * allowing auth middleware that runs after the agent middleware to still
     * propagate auth to agents.
     */
    get auth(): AuthInterface | null;
    /**
     * Set auth for non-HTTP contexts (standalone, tests).
     * @internal
     */
    set auth(value: AuthInterface | null);
    constructor(args: RequestAgentContextArgs<TAgentMap, TConfig, TAppState>);
    waitUntil(callback: Promise<void> | (() => void | Promise<void>)): void;
}
export declare const inAgentContext: () => boolean;
export declare const inHTTPContext: () => boolean;
export declare const getAgentContext: () => AgentContext<any, any, any>;
export declare const getHTTPContext: () => HonoContext;
export declare const getAgentAsyncLocalStorage: () => AsyncLocalStorage<AgentContext<any, any, any>>;
export declare const getHTTPAsyncLocalStorage: () => AsyncLocalStorage<HonoContext<any, any, {}>>;
/**
 * Get the current executing agent's metadata (for internal telemetry use only).
 * Returns undefined if not in an agent context or no agent is executing.
 * @internal
 */
export declare const getCurrentAgentMetadata: () => AgentRunner["metadata"] | undefined;
export declare const setupRequestAgentContext: <TAgentMap extends AgentRegistry = AgentRegistry, TConfig = unknown, TAppState = Record<string, never>>(ctxObject: Record<string, unknown>, args: RequestAgentContextArgs<TAgentMap, TConfig, TAppState>, next: () => Promise<void>) => Promise<void>;
export declare const runInHTTPContext: <HonoContext>(ctx: HonoContext, next: () => Promise<void>) => Promise<void>;
//# sourceMappingURL=_context.d.ts.map