/**
 * Base error for PostgreSQL-related errors.
 */
export declare const PostgresError: {
    new (args?: ({
        code?: string;
        query?: string;
    } & {
        message?: string;
        cause?: unknown;
    }) | undefined): import("@agentuity/core").RichError & {
        readonly _tag: "PostgresError";
    } & Readonly<{
        code?: string;
        query?: string;
    }>;
    readonly defaultMessage?: string;
};
/**
 * Error thrown when attempting to use a closed connection.
 */
export declare const ConnectionClosedError: {
    new (args?: ({
        wasReconnecting?: boolean;
    } & {
        message?: string;
        cause?: unknown;
    }) | undefined): import("@agentuity/core").RichError & {
        readonly _tag: "ConnectionClosedError";
    } & Readonly<{
        wasReconnecting?: boolean;
    }>;
    readonly defaultMessage?: string;
};
/**
 * Error thrown when reconnection fails after all attempts.
 */
export declare const ReconnectFailedError: {
    new (args?: ({
        attempts: number;
        lastError?: Error;
    } & {
        cause?: unknown;
    }) | undefined): import("@agentuity/core").RichError & {
        readonly _tag: "ReconnectFailedError";
    } & Readonly<{
        attempts: number;
        lastError?: Error;
    }>;
    readonly defaultMessage?: string;
};
/**
 * Error thrown when a query times out.
 */
export declare const QueryTimeoutError: {
    new (args?: ({
        timeoutMs: number;
        query?: string;
    } & {
        cause?: unknown;
    }) | undefined): import("@agentuity/core").RichError & {
        readonly _tag: "QueryTimeoutError";
    } & Readonly<{
        timeoutMs: number;
        query?: string;
    }>;
    readonly defaultMessage?: string;
};
/**
 * Error thrown when a transaction fails.
 */
export declare const TransactionError: {
    new (args?: ({
        phase?: "begin" | "commit" | "rollback" | "savepoint" | "query";
    } & {
        message?: string;
        cause?: unknown;
    }) | undefined): import("@agentuity/core").RichError & {
        readonly _tag: "TransactionError";
    } & Readonly<{
        phase?: "begin" | "commit" | "rollback" | "savepoint" | "query";
    }>;
    readonly defaultMessage?: string;
};
/**
 * Error thrown when an operation is not supported.
 */
export declare const UnsupportedOperationError: {
    new (args?: ({
        operation: string;
        reason?: string;
    } & {
        cause?: unknown;
    }) | undefined): import("@agentuity/core").RichError & {
        readonly _tag: "UnsupportedOperationError";
    } & Readonly<{
        operation: string;
        reason?: string;
    }>;
    readonly defaultMessage?: string;
};
/**
 * Determines if an error is retryable (i.e., a reconnection should be attempted).
 *
 * @param error - The error to check
 * @returns `true` if the error indicates a connection issue that may be resolved by reconnecting
 */
export declare function isRetryableError(error: unknown): boolean;
//# sourceMappingURL=errors.d.ts.map