const store = new Map();
function makeTodoError(code, message, field) {
    const error = { code, message };
    if (field !== undefined) {
        error.field = field;
    }
    return error;
}
export function createTodo(text) {
    const trimmed = text.trim();
    if (!trimmed) {
        throw makeTodoError('VALIDATION_ERROR', 'text must not be empty', 'text');
    }
    const todo = {
        id: crypto.randomUUID(),
        text: trimmed,
        completed: false,
        createdAt: Date.now(),
    };
    store.set(todo.id, todo);
    return todo;
}
export function listTodos() {
    return Array.from(store.values()).sort((a, b) => b.createdAt - a.createdAt);
}
export function completeTodo(id) {
    const todo = store.get(id);
    if (!todo) {
        throw makeTodoError('NOT_FOUND', `todo with id '${id}' not found`, 'id');
    }
    const updated = { ...todo, completed: true };
    store.set(id, updated);
    return updated;
}
export function deleteTodo(id) {
    const todo = store.get(id);
    if (!todo) {
        throw makeTodoError('NOT_FOUND', `todo with id '${id}' not found`, 'id');
    }
    store.delete(id);
    return todo;
}
//# sourceMappingURL=store.js.map