/**
 * Interactive code review command.
 *
 * Provides `/review` with 4 modes:
 *   1. PR-style review against a base branch
 *   2. Review uncommitted changes (staged + unstaged)
 *   3. Review a specific commit
 *   4. Custom review instructions (no diff)
 *
 * Gathers diff/instructions, parses stats, and sends
 * a formatted review prompt to the @reviewer agent.
 */
import type { ExtensionAPI, ExtensionCommandContext } from '@mariozechner/pi-coding-agent';
export declare function handleReview(args: string, ctx: ExtensionCommandContext, pi: ExtensionAPI): Promise<void>;
//# sourceMappingURL=review.d.ts.map