/**
 * TUI tool renderers for Hub tools.
 *
 * Each renderer provides a compact renderCall (one-line summary of the invocation)
 * and a renderResult (collapsed / expanded views of the result).
 * Renderers are looked up by tool name and spread into the registerTool() call.
 */
import type { Theme, ToolRenderResultOptions, AgentToolResult } from '@mariozechner/pi-coding-agent';
import { type Component } from '@mariozechner/pi-tui';
/**
 * Truncate a string (possibly containing ANSI escape codes) to fit within
 * a given visible width. Handles escape sequences properly so colours are
 * never broken — a RESET is appended when truncation occurs.
 */
export declare function truncateToWidth(line: string, maxWidth: number): string;
export declare class SimpleText {
    private text;
    constructor(text: string);
    render(width: number): string[];
    invalidate(): void;
}
type RenderCallFn = (args: Record<string, unknown>, theme: Theme) => Component;
type RenderResultFn = (result: AgentToolResult<unknown>, options: ToolRenderResultOptions, theme: Theme) => Component;
export interface ToolRenderers {
    renderCall?: RenderCallFn;
    renderResult?: RenderResultFn;
}
/**
 * Look up renderCall / renderResult functions for a Hub tool.
 * Returns undefined for tools without custom rendering.
 */
export declare function getToolRenderers(toolName: string): ToolRenderers | undefined;
export {};
//# sourceMappingURL=renderers.d.ts.map