import type { Theme } from '@mariozechner/pi-coding-agent';
import type { AgentDefinition } from './protocol.ts';
export interface AgentManagerResult {
    agent: string;
    action: 'run';
}
interface Component {
    render(width: number): string[];
    handleInput?(data: string): void;
    invalidate(): void;
}
interface Focusable {
    focused: boolean;
}
type DoneFn = (result: AgentManagerResult | undefined) => void;
export declare class AgentManagerOverlay implements Component, Focusable {
    focused: boolean;
    private readonly theme;
    private readonly agents;
    private readonly done;
    private screen;
    private selectedIndex;
    private readonly listWindowSize;
    private disposed;
    constructor(theme: Theme, agents: AgentDefinition[], done: DoneFn);
    handleInput(data: string): void;
    render(width: number): string[];
    invalidate(): void;
    dispose(): void;
    private handleListInput;
    private handleDetailInput;
    private close;
    private renderListScreen;
    private renderDetailScreen;
    private fieldLine;
    private contentLine;
    private getVisibleRange;
}
export {};
//# sourceMappingURL=overlay.d.ts.map