import { type Theme } from '@mariozechner/pi-coding-agent';
export interface StoredResult {
    agentName: string;
    text: string;
    thinking: string;
    timestamp: number;
    tokenInfo?: string;
    description?: string;
    prompt?: string;
    isStreaming: boolean;
}
interface Component {
    render(width: number): string[];
    handleInput?(data: string): void;
    invalidate(): void;
}
interface Focusable {
    focused: boolean;
}
type DoneFn = (result: undefined) => void;
interface TUIRef {
    requestRender(): void;
}
export declare class OutputViewerOverlay implements Component, Focusable {
    focused: boolean;
    private readonly tui;
    private readonly theme;
    private readonly results;
    private readonly done;
    private currentIndex;
    private scrollOffset;
    private disposed;
    private viewMode;
    private showThinking;
    private following;
    private pollTimer;
    private mdRenderer;
    constructor(tui: TUIRef, theme: Theme, results: StoredResult[], done: DoneFn, startIndex?: number);
    handleInput(data: string): void;
    render(width: number): string[];
    invalidate(): void;
    dispose(): void;
    private getContentLines;
    private getContentBudget;
    private contentLine;
    private close;
}
export {};
//# sourceMappingURL=output-viewer.d.ts.map